<?php

namespace Avodel\WebDriver\Profile;


final readonly class Profile
{
    public function __construct(
        private string $wdUrl,
        private int $baseTypingCpm,
        private ?string $sessionId,
        private ?string $userDataDir,
        private ?Proxy $proxy,
        private ?UserAgent $userAgent,
        private ?string $locale,
        private ?string $timezoneId,
        private ?DeviceMetrics $deviceMetrics,
        private ?Preferences $preferences,
    )
    {
    }

    public function getWdUrl(): string
    {
        return $this->wdUrl;
    }

    public function getUserDataDir(): ?string
    {
        return $this->userDataDir;
    }

    public function getSessionId(): ?string
    {
        return $this->sessionId;
    }

    public function getProxy(): ?Proxy
    {
        return $this->proxy;
    }

    public function getUserAgent(): ?UserAgent
    {
        return $this->userAgent;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    public function getTimezoneId(): ?string
    {
        return $this->timezoneId;
    }

    public function getDeviceMetrics(): ?DeviceMetrics
    {
        return $this->deviceMetrics;
    }

    public function getPreferences(): ?Preferences
    {
        return $this->preferences;
    }

    public function getBaseTypingCpm(): int
    {
        return $this->baseTypingCpm;
    }

    public static function builder(): ProfileBuilder
    {
        return new ProfileBuilder();
    }
}
