<?php

namespace Avodel\WebDriver\Profile;

use InvalidArgumentException;

final class SessionBag
{
    private array $data = [];

    public function set(string $key, mixed $value): void
    {
        $this->data[$key] = $value;
    }

    public function get(string $key): mixed
    {
        if (!array_key_exists($key, $this->data)) {
            throw new InvalidArgumentException('Unknown key');
        }

        return $this->data[$key];
    }
}
