<?php

namespace Avodel\WebDriver\Extension;

use Avodel\WebDriver\Driver\DevToolsDriver;
use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class UserAgentWebDriverExtension implements WebDriverExtensionInterface
{
    public function __construct(
        private string $userAgent,
    )
    {
    }

    public function apply(RemoteWebDriver $webDriver): void
    {
        $devToolsDriver = new DevToolsDriver(new ChromeDevToolsDriver($webDriver));
        $devToolsDriver->setUserAgentOverride($this->userAgent);
    }
}
