<?php

namespace Avodel\WebDriver\Extension;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class StealthWebDriverExtension implements WebDriverExtensionInterface
{
    public function apply(RemoteWebDriver $webDriver): void
    {
        $devTools = new ChromeDevToolsDriver($webDriver);
        $this->addScriptToEvaluateOnNewDocument($devTools, 'utils.js');
//        $this->addScriptToEvaluateOnNewDocument($devTools, 'chrome.app.js');
//        $this->addScriptToEvaluateOnNewDocument($devTools, 'chrome.runtime.js');
//        $this->addScriptToEvaluateOnNewDocument($devTools, 'media.codecs.js');
//        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.permissions.js');

        $this->addScriptToEvaluateOnNewDocument($devTools, 'webgl.vendor.js');


        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.plugins.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'window.outerdimensions.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'iframe.contentWindow.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'hook_remove_cdc_props.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.rtt.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.brave.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'chrome.loadTimes.js');


        $this->addScriptToEvaluateOnNewDocument($devTools, 'hairline.fix.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.platform.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.languages.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.vendor.js');
        $this->addScriptToEvaluateOnNewDocument($devTools, 'navigator.webdriver.js');

//        $this->addScriptToEvaluateOnNewDocument($devTools, 'chrome.csi.js');
    }


    private function addScriptToEvaluateOnNewDocument(ChromeDevToolsDriver $devTools, string $source): void
    {
        $devTools->execute('Page.addScriptToEvaluateOnNewDocument', [
            'source' => file_get_contents(__DIR__ . '/../Resources/js/stealth/' . $source),
        ]);
    }
}
