<?php

namespace Avodel\WebDriver\DependencyInjection;

use Avodel\WebDriver\Mouse\BasicMousePathStrategy;
use Avodel\WebDriver\Profile\FallbackProfileManager;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_web_driver');

        // @phpstan-ignore-next-line
        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('profile_manager')->defaultValue(FallbackProfileManager::class)->end()
                ->booleanNode('auto_accept_cookies')->defaultValue(false)->end()
                ->arrayNode('timeouts')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('implicit')->defaultValue(0)->end()
                        ->scalarNode('page_load')->defaultValue(null)->end()
                        ->scalarNode('script')->defaultValue(30)->end()
                    ->end()
                ->end()
                ->arrayNode('mouse')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('enable_tracker')->defaultValue(false)->end()
                        ->scalarNode('path_strategy')->defaultValue(BasicMousePathStrategy::class)->end()
                    ->end()
                ->end()
                ->arrayNode('components')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('debug')->defaultValue('file:///app/.debug')->end()
                        ->arrayNode('captcha_verifier')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->arrayNode('solvers')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('hcaptcha')->defaultValue(null)->end()
                                        ->scalarNode('recaptcha_v2')->defaultValue(null)->end()
                                        ->scalarNode('cloudflare_turnstile')->defaultValue(null)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('ajax')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('max_waiting_time_ms')->defaultValue(80000)->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('typing_accuracy_config')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->floatNode('accuracy')->defaultValue(1)->end()
                        ->arrayNode('on_typo_delay')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('min')->defaultValue(500)->end()
                                ->integerNode('max')->defaultValue(1500)->end()
                            ->end()
                        ->end()
                        ->arrayNode('backspace_delay')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('min')->defaultValue(100)->end()
                                ->integerNode('max')->defaultValue(200)->end()
                            ->end()
                        ->end()
                        ->arrayNode('after_typo_fixed_delay')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('min')->defaultValue(200)->end()
                                ->integerNode('max')->defaultValue(600)->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('extensions')
                    ->scalarPrototype()->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
