<?php

namespace Avodel\WebDriver\DependencyInjection;

use Avodel\WebDriver\Driver\MinkPhpWebDriverFactory;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

final readonly class LoadWebDriverExtensionsCompilerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $extensions = [];

        foreach ($container->getParameter('avodel.web_driver.extensions') as $extension) {
            $extensions[] = $container->getDefinition($extension);
        }

        $container->getDefinition(MinkPhpWebDriverFactory::class)->replaceArgument('$extensions', $extensions);
        $container->getParameterBag()->remove('avodel.web_driver.extensions');
    }
}
